% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectors.R
\name{random_vector}
\alias{random_vector}
\title{Generate a random vector of desired type}
\usage{
random_vector(size, type, custom_generator = NULL, unique = FALSE, ...)
}
\arguments{
\item{size}{integer, vector length}

\item{type}{"integer", "string", "boolean", "date", "time",
"datetime" or "numeric" type of vector values.
If custom generator provided, should be set to "custom".}

\item{custom_generator}{function or string, custom value generator.
Can be a function or a string with function name. Default: NULL}

\item{unique}{boolean, should the output contain only unique values. Default: FALSE.}

\item{...}{arguments passed to function responsible for generating values.
Check \code{\link{random_integer}}, \code{\link{random_string}}, \code{\link{random_boolean}}
and \code{\link{random_numeric}} for details}
}
\value{
vector of random values of chosen type
}
\description{
Generate a random vector of desired type
}
\examples{
random_vector(5, "boolean")
random_vector(10, "numeric", min = 1.5, max = 5)
random_vector(4, "string", length = 4, pattern = "[ACGT]")
random_vector(2, "integer", max = 10)

# custom generator
custom_generator <- function() sample(c("A", "B"), 1)
random_vector(3, type = "custom", custom_generator = custom_generator)
}
