% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_backfit.R
\name{flash_backfit}
\alias{flash_backfit}
\title{Backfit a flash object}
\usage{
flash_backfit(
  flash,
  kset = NULL,
  extrapolate = TRUE,
  warmstart = TRUE,
  maxiter = 500,
  tol = NULL,
  verbose = NULL
)
}
\arguments{
\item{flash}{A \code{flash} or \code{flash_fit} object.}

\item{kset}{A vector of integers specifying which factors to backfit.
If \code{kset = NULL}, then all existing factors will be backfitted.}

\item{extrapolate}{Whether to use an extrapolation technique
inspired by Ang and Gillis (2019) to accelerate the fitting process.
Control parameters are handled via global options and can be set by
calling \code{options("extrapolate.control") <- control.param}.}

\item{warmstart}{Whether to use "warmstarts" when solving the EBNM
subproblems by initializing solutions at the previous value of the fitted
prior \eqn{\hat{g}}. An important side effect of warmstarts for
\code{ashr}-like prior families is to fix the grid at its initial setting.
Fixing the grid can lead to poor fits if there
are large changes in the scale of the estimated prior over the
course of the fitting process. However, allowing the grid to
vary can occasionally result in decreases in ELBO.}

\item{maxiter}{The maximum number of backfitting iterations. An "iteration"
is defined such that all factors in \code{kset} get updated at each
iteration.}

\item{tol}{The convergence tolerance parameter. After each update, the fit
is compared to the fit from before the update using a convergence
criterion function (by default, the difference in ELBO, but the criterion
can be changed via \code{\link{flash_set_conv_crit}}).
The backfit is considered to have "converged" when the value of the
convergence criterion function over successive updates to
\emph{all} factor/loadings pairs is less than or equal to \code{tol}. If,
for example, factor/loadings pairs \eqn{1, \ldots, K} are being
sequentially backfitted, then fits are compared before and
after the update to factor/loadings 1, before and after the update to
factor/loadings 2, and so on through factor/loadings \eqn{K},
and backfitting only terminates when the convergence criterion function
returns a value less
than or equal to \code{tol} for all \eqn{K} updates. Note that
specifying \code{tol} here will override any value set by
\code{flash_set_conv_crit}; to use the "global" tolerance parameter,
\code{tol} must be left unspecified (\code{NULL}).
If \code{tol = NULL} and a global tolerance
parameter has not been set, then the default
tolerance used is \eqn{np\sqrt{\epsilon}}, where \eqn{n} is the
number of rows in the dataset, \eqn{p} is the number of columns, and
\eqn{\epsilon} is equal to \code{\link{.Machine}$double.eps}.}

\item{verbose}{When and how to display progress updates. Set to
\code{0} for none, \code{1} for updates after a factor is added or a
backfit is completed, \code{2} for additional notifications about the
variational lower bound, and \code{3} for updates after every iteration.
It is also possible to output a single tab-delimited table of values
using function \code{\link{flash_set_verbose}} with \code{verbose = -1}.}
}
\value{
The \code{\link{flash}} object from argument \code{flash}, backfitted
  as specified.
}
\description{
Backfits existing flash factor/loadings pairs. Whereas a "greedy" fit optimizes
  each newly added factor/loadings pair in one go without returning to optimize
  previously added pairs, a "backfit" updates all existing pairs in a cyclical
  fashion. See \code{\link{flash}} for examples of usage.
}
