% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_set_timeout.R
\name{flash_set_timeout}
\alias{flash_set_timeout}
\title{Set timeout}
\usage{
flash_set_timeout(
  flash,
  tim,
  units = c("hours", "secs", "mins", "days", "weeks")
)
}
\arguments{
\item{flash}{A \code{flash} or \code{flash_fit} object.}

\item{tim}{A numeric value giving the maximum amount of fitting time, with
the units of time specified by parameter \code{units}.}

\item{units}{The units of time according to which parameter \code{tim} is to
be interpreted.}
}
\value{
The \code{\link{flash}} object from argument \code{flash}, with the
  timeout settings reflected in updates to the "internal" \code{flash_fit}
  object. These settings will persist across all subsequent calls to
  \code{flash_xxx} functions until they are modified either by
  \code{\link{flash_clear_timeout}} or by another call to
  \code{flash_set_timeout}.
}
\description{
Used in a \code{\link{flash}} pipeline to set a maximum amount of fitting
  time. Note that timeout conditions are only checked during greedy fits
  and backfits, so that the total amount of fitting time can exceed the time
  set by \code{flash_set_timeout} (especially if, for example, there is a
  nullcheck involving many factor/loading pairs). Also note that timeout
  conditions must be cleared using function \code{\link{flash_clear_timeout}}
  before any re-fitting is attempted.
}
\examples{
fl <- flash_init(gtex) \%>\%
  flash_set_timeout(1, "secs") \%>\%
  flash_greedy(Kmax = 30) \%>\%
  flash_backfit() \%>\%
  flash_nullcheck() \%>\%
  flash_clear_timeout() # Always clear timeout at the end of a pipeline.

}
