#' @title
#' Multi state data
#'
#' @description Simulated multi-state data with 4 states expanded in msdata format
#' @usage data(msdata_4state)
#' @format A dataframe with 9198 rows and 4 variables expanded in wide format for 10 orders of transitions
#' \describe{
#' \item{id}{ID of subjects}
#' \item{from}{From which state the individual is shifting}
#' \item{to}{To which state the individual is shifting}
#' \item{trans}{Order of transition of a particular individual at a specific time}
#' \item{Tstart}{Starting time of a transition}
#' \item{Tstop}{Stop time of a transition}
#' \item{time}{Total time duration of a particular transition}
#' \item{status}{Indicator of that particular transition}
#' \item{x1,...,x4}{4 continuous covariates originally in the dataset}
#' \item{x1.1,...,x4.10}{The 4 covariates expanded in 10 orders of transitions}}
#' @examples data(msdata_4state)
"msdata_4state"
#'
#' @title
#' Short Multi state data
#'
#' @description Simulated multi-state data with 3 states expanded in msdata format
#' @usage data(msdata_3state)
#' @format A dataframe with 12 rows and 2 variables expanded in wide format for 3 orders of transitions
#' \describe{
#' \item{id}{ID of subjects}
#' \item{from}{From which state the individual is shifting}
#' \item{to}{To which state the individual is shifting}
#' \item{trans}{Order of transition of a particular individual at a specific time}
#' \item{Tstart}{Starting time of a transition}
#' \item{Tstop}{Stop time of a transition}
#' \item{time}{Total time duration of a particular transition}
#' \item{status}{Indicator of that particular transition}
#' \item{x1,x2}{2 continuous covariates originally in the dataset}
#' \item{x1.1,...,x2.3}{The 2 covariates expanded in 3 orders of transitions}}
#' @examples data(msdata_3state)
"msdata_3state"
#'
#' @title
#' Multi state data with high dimensional covariates
#'
#' @description Multi state data with 3 states, 100 continuous biomarkers
#' @usage data(highDmsm)
#' @format A dataframe with 500 rows and 107 columns including all the states and covariates
#' \describe{
#' \item{id}{ID of subjects}
#' \item{state1}{Time in days from transplantation to state-1 or last follow up}
#' \item{status1}{Status of state-1}
#' \item{state2}{Time in days from transplantation to state-2 or last follow up}
#' \item{status2}{Status of state-1}
#' \item{state3,status3}{Time in days from transplant to the respective states along with its status}
#' \item{v1,...,v100}{The 100 biomarkers attached to the dataset }
#' }
#' @examples
#' data(highDmsm)
"highDmsm"

