% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flassomsm_admm.R
\name{flassomsm_admm}
\alias{flassomsm_admm}
\title{flassomsm_admm}
\usage{
flassomsm_admm(
  msdata,
  X,
  p,
  lambda_lasso,
  lambda_fused,
  tol_admm = 1e-04,
  max_admm = 100,
  rho = 1,
  trace = TRUE,
  MSM_profile = FALSE
)
}
\arguments{
\item{msdata}{is a multi-state model in extended form having columns Tstart,Tstop,trans (covariates expanded transition wise)}

\item{X}{expanded covariate matrix of the msdata}

\item{p}{number of covariates in the dataset before expanding}

\item{lambda_lasso}{parameter for lasso penalty}

\item{lambda_fused}{parameter for fused penalty}

\item{tol_admm}{tolerence limit in the algorithm to stop}

\item{max_admm}{maximum number of iterations reached}

\item{rho}{augmented Lagrangian parameter}

\item{trace}{logical triggering for status information}

\item{MSM_profile}{logical triggering to return the results}
}
\value{
A list with elements like matrix of estimated beta coefficients along with standard error and p value,number of iterations, aic (Akaike Information Criterion) value, gcv (GCV criterion) value and df (degrees of freedom)
}
\description{
Fits a penalized regression model with combined Fusedlasso penalty using ADMM algorithm
}
\details{
This function fits a penalized Cox type regression model to a multi-state setting,
where the penalty is a combination of Lasso penalty and Fused penalty. It applies
L1 type penalization with the penalty applied to absolute transition-specific effects
and pairwise difference between the corresponding transition effects and alternating
direction method of multipliers (ADMM) algorithm.
}
\examples{
##
set.seed(123)
data(msdata_3state)
covs1 <- msdata_3state[,9:10]
flassomsm_admm(msdata = msdata_3state,X=msdata_3state[,c(11:dim(msdata_3state)[[2]])],
p = length(covs1),lambda_lasso = 0.3,lambda_fused = 0.5,tol_admm = 1e-4,max_admm = 10,
rho = 1, trace = TRUE, MSM_profile = FALSE)

# For 2 covariates and 3 number of transitions

\donttest{
# Simulate msdata_4state instead of loading from disk
msdata_4state <- simdata(seed=123,n=1000,dist="weibull",cdist="exponential",
                 cparams=list(rate = 0.1),lambdas=c(0.1, 0.2, 0.3, 0.4),
                 gammas=c(1.5, 2, 2.5, 2.6),beta_list=list(c(-0.05, 0.01, 0.5, 0.6),
                 c(-0.03, 0.02, 0.07, 0.08),c(-0.04, 0.03, 0.04, -0.03),
                 c(-0.05, 0.05, 0.6, 0.8)),cov_means=c(0, 10, 2, 3),
                 cov_sds=c(1, 20, 5, 1.05),trans_list=list(c(2, 3, 4, 5),
                 c(3,4,5),c(4,5),c(5),c()),state_names=c("Tx","Rec","Death","Reldeath","srv"))
set.seed(123)
sub_msdata_4state <- msdata_4state[msdata_4state$id \%in\% sample(unique(msdata_4state$id), 10), ]
covs1 <- sub_msdata_4state[,9:10]
flassomsm_admm(msdata = sub_msdata_4state,X=sub_msdata_4state[,c(13:32)],
              p = length(covs1),lambda_lasso = 0.5,lambda_fused = 0.6,
              tol_admm = 1e-4,max_admm = 10,rho = 1, trace = TRUE,
              MSM_profile = FALSE)
}
# For 2 covariates and 10 number of transitions
##
}
\author{
Atanu Bhattacharjee,Gajendra Kumar Vishwakarma,Abhipsa Tripathy
}
