% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri.R
\name{Triangular}
\alias{Triangular}
\alias{dtri}
\alias{ptri}
\alias{qtri}
\alias{rtri}
\title{Triangle Distribution}
\usage{
dtri(x, mode = 0, sigma = 1, upper = NA, lower = NA, log = FALSE)

ptri(
  q,
  mode = 0,
  sigma = 1,
  upper = NA,
  lower = NA,
  lower.tail = TRUE,
  log.p = FALSE
)

qtri(p, mode = 0, sigma = 1, upper = NA, lower = NA)

rtri(n, mode = 0, sigma = 1, upper = NA, lower = NA)
}
\arguments{
\item{x}{numeric value or a vector of values.}

\item{mode}{numeric value or vector of mode values for the distribution.}

\item{sigma}{single value or vector indicating both the positive and negative
max differences from the mean (if the difference is the same).}

\item{upper}{single value or vector for the upper limit of the distribution
(must be used with `lower`).}

\item{lower}{single value or vector for the lower limit of the distribution
(must be used with `upper`).}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{quantile or a vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{probability or a vector of probabilities.}

\item{n}{the number of random numbers to generate.}
}
\value{
dtri gives the density, ptri gives the distribution function, qtri 
gives the quantile function, and rtri generates random deviates.

The length of the result is determined by n for rtri, and is the maximum of 
the lengths of the numerical arguments for the other functions.

The numerical arguments other than n are recycled to the length of the 
result. Only the first elements of the logical arguments are used.
}
\description{
These functions provide density, distribution function, quantile function,
and random number generation for the Triangle Distribution, specified by its
mean, standard deviation, and optional lower and upper bounds.
}
\details{
The Triangle Distribution is defined by three points: a (minimum), b
(maximum), and c (mode), where the density is zero outside the interval [a,
b], increases linearly from a to c, and decreases linearly from c to b.


\code{dtri} computes the density (PDF) of the Triangle Distribution.

\code{ptri} computes the CDF of the Triangle Distribution.

\code{qtri} computes the quantile function of the Triangle Distribution.

\code{rtri} generates random numbers from the Triangle Distribution.

The mode and standard deviation parameters define the distribution's location
and scale, respectively, while the lower and upper bounds explicitly set the
minimum and maximum values of the distribution.
}
\examples{
dtri(4, mode=8, upper=13, lower=1)
ptri(c(0, 1, 2, 3, 5, 7, 9, 10), mode = 3, upper=9, lower = 1)
qtri(c(0.1, 0.3, 0.5, 0.9, 0.95), mode = 3, upper = 9, lower = 1)
rtri(30, mode = 5, sigma = 3)

}
