% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countregrp.R
\name{countreg.rp}
\alias{countreg.rp}
\title{Random Parameters Count Regression Models}
\usage{
countreg.rp(
  formula,
  rpar_formula,
  data,
  family = "NB2",
  rpardists = NULL,
  dis_param_formula_1 = NULL,
  dis_param_formula_2 = NULL,
  het_mean_formula = NULL,
  het_var_formula = NULL,
  ndraws = 500,
  scrambled = FALSE,
  correlated = FALSE,
  panel_id = NULL,
  weights = NULL,
  offset = NULL,
  method = "BHHH",
  max.iters = 1000,
  start.vals = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{an R formula. This formula should specify the outcome and the
independent variables that have fixed parameters.}

\item{rpar_formula}{a symbolic description of the model related specifically
to the random parameters. This should not include an outcome variable. If
the intercept is random, include it in this formula. If the intercept is
fixed, include it in \code{formula} but not in \code{rpar_formula}.}

\item{data}{a dataframe that has all of the variables in the \code{formula}
and \code{rpar_formula}.}

\item{family}{the name of the distribution/model type to estimate. Default is
"NB2". Options include "Poisson", "NB1", "NB2", "NBP", "PIG", "Sichel",
etc. (See \code{\link{countreg}} for full list).}

\item{rpardists}{an optional named vector whose names are the random
parameters and values the distribution. The distribution options include
normal ("n"), lognormal ("ln"), triangular ("t"), uniform ("u"), and gamma
("g"). If not provided, normal is used.}

\item{dis_param_formula_1}{a symbolic description of the model for the 
first parameter of the count distribution (e.g., ln(alpha) for NB2).}

\item{dis_param_formula_2}{a symbolic description of the model for the 
second parameter of the count distribution (if applicable).}

\item{het_mean_formula}{an optional symbolic description of the model 
for heterogeneity in the means of the random parameters.}

\item{het_var_formula}{an optional symbolic description of the model 
for heterogeneity in the variances of the random parameters.}

\item{ndraws}{the number of Halton draws to use for estimating the random 
parameters.}

\item{scrambled}{if the Halton draws should be scrambled.}

\item{correlated}{if the random parameters should be correlated. 
If TRUE, only normal distributions are used.}

\item{panel_id}{an optional variable name (string) or vector defining the
panel structure (repeated measures). If provided, the standard errors and
likelihood are estimated accounting for the panel structure.}

\item{weights}{variable name to be used as frequency weights.}

\item{offset}{variable name to be used as an offset.}

\item{method}{optimization method (e.g., "BHHH", "BFGS", "NM").}

\item{max.iters}{maximum number of iterations.}

\item{start.vals}{optional vector of starting values.}

\item{verbose}{logical.}
}
\value{
An object of class `countreg` which is a list with the following components:
\itemize{
 \item model: the fitted model object.
 \item data: the data frame used to fit the model.
 \item call: the matched call.
 \item formula: the formula used to fit the model.
}
}
\description{
Random Parameters Count Regression Models
}
\examples{
\donttest{
# Load data
data("washington_roads")
washington_roads$AADT10kplus <- ifelse(washington_roads$AADT > 10000, 1, 0)

# 1. Basic Random Parameters Negative Binomial (NB2)
rp_nb2 <- countreg.rp(Total_crashes ~ lnaadt + lnlength,
                      rpar_formula = ~ -1 + speed50,
                      data = washington_roads,
                      family = "NB2",
                      rpardists = c(speed50 = "n"),
                      ndraws = 100,
                      method = "BHHH")
summary(rp_nb2)

# 2. Random Parameters with Panel Structure (if 'site_id' exists)
# rp_panel <- countreg.rp(Total_crashes ~ -1 + lnaadt,
#                        rpar_formula = ~ speed50,
#                        data = washington_roads,
#                        panel_id = "site_id",
#                        family = "NB2",
#                        ndraws = 100)

# 3. Generalized Random Parameters Model with Heterogeneity
rp_gen <- countreg.rp(Total_crashes ~ lnaadt,
                      rpar_formula = ~ -1 + speed50,
                      dis_param_formula_1 = ~ lnlength, 
                      het_mean_formula = ~ AADT10kplus,
                      data = washington_roads,
                      family = "NB2",
                      rpardists = c(speed50 = "n"),
                      ndraws = 100)
summary(rp_gen)

# 4. Random Parameters Poisson Model with panel specification
rp_poisson <- countreg.rp(Total_crashes ~ lnaadt,
                      rpar_formula = ~ -1 + speed50,
                      dis_param_formula_1 = ~ lnlength, 
                      het_mean_formula = ~ AADT10kplus,
                      data = washington_roads,
                      family = "POISSON",
                      rpardists = c(speed50 = "n"),
                      ndraws = 100,
                      panel_id = "ID")
summary(rp_poisson)
}

}
