% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renb.R
\name{renb}
\alias{renb}
\title{Estimate a Random Effects Negative Binomial regression model}
\usage{
renb(
  formula,
  group_var,
  data,
  method = "NM",
  max.iters = 1000,
  print.level = 0,
  bootstraps = NULL,
  offset = NULL
)
}
\arguments{
\item{formula}{an R formula.}

\item{group_var}{the grouping variable(s) for the random effects (e.g.,
individual ID or other panel ID variables).}

\item{data}{a dataframe that has all of the variables in the \code{formula}.}

\item{method}{a method to use for optimization in the maximum likelihood
estimation. For options, see \code{\link[maxLik]{maxLik}}. Note that "BHHH"
is not available for this function due to the implementation for the random
effects.}

\item{max.iters}{the maximum number of iterations to allow the optimization
method to perform.}

\item{print.level}{Integer specifying the verbosity of output during
optimization.}

\item{bootstraps}{Optional integer specifying the number of bootstrap samples
to be used for estimating standard errors. If not specified, no
bootstrapping is performed.}

\item{offset}{an optional offset term provided as a string.}
}
\value{
An object of class `countreg` which is a list with the following components:
\itemize{
 \item model: the fitted model object.
 \item data: the data frame used to fit the model.
 \item call: the matched call.
 \item formula: the formula used to fit the model.
}
}
\description{
Estimate a Random Effects Negative Binomial regression model
}
\details{
This function estimates a random effects negative binomial (RENB) regression 
model. This model is based on the NB-1 model. The PDF for the RENB is:
\deqn{f(y_{it}|\mu_{it}, a, b) = 
  \frac{\Gamma(a+b) + 
    \Gamma(a + \sum_{t = 1}^{n_i} \mu_{it}) + 
    \Gamma(b + \sum_{t=1}^{n_i}y_{it})}
    {\Gamma(a) \Gamma(b) \Gamma(a + b + 
       \sum_{t=1}^{n_i}\mu_{it} + \sum_{t=1}^{n_i}y_{it})} \prod_{t=1}^{n_i}
       \frac{\Gamma(\mu_{it}+y_{it})}{\Gamma(\mu_{it})\Gamma(y_{it})}}
}
\examples{
\donttest{
## RENB Model
data("washington_roads")
washington_roads$AADTover10k <- 
  ifelse(washington_roads$AADT > 10000, 1, 0) # create a dummy variable
renb.mod <- renb(Animal ~ lnaadt + speed50 + ShouldWidth04 + AADTover10k,
                                data=washington_roads,
                                offset = "lnlength",
                                group_var="ID",
                                method="nm",
                                max.iters = 1000)
summary(renb.mod)
}
}
