% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rimse.R
\name{rimse}
\alias{rimse}
\title{Root Integrated Mean Squared Difference Between FMP IRFs}
\usage{
rimse(
  bvec1,
  bvec2,
  ncat = 2,
  c1 = NULL,
  d1 = NULL,
  c2 = NULL,
  d2 = NULL,
  int = int_mat()
)
}
\arguments{
\item{bvec1}{Either a vector of FMP item parameters or a function
corresponding to a non-FMP IRF. Functions should have exactly one argument,
corresponding to the latent trait.}

\item{bvec2}{Either a vector of FMP item parameters or a function
corresponding to a non-FMP IRF. Functions should have exactly one argument,
corresponding to the latent trait.}

\item{ncat}{Number of response categories (first ncat - 1 elemnts of bvec1
and bvec2 are intercepts)}

\item{c1}{Lower asymptote parameter for bvec1.
Ignored if bvec1 is a function.}

\item{d1}{Upper asymptote parameter for bvec1.
Ignored if bvec1 is a function.}

\item{c2}{Lower asymptote parameter for bvec2.
Ignored if bvec2 is a function.}

\item{d2}{Upper asymptote parameter for bvec2.
Ignored if bvec2 is a function.}

\item{int}{Matrix with two columns, used for numerical integration.
Column 1 is a grid of theta values, column 2 are normalized densities
associated with the column 1 values}
}
\value{
Root integrated mean squared difference between two IRFs
(dichotomous items) or expected item scores (polytomous items).
}
\description{
Compute the root integrated mean squared error (RIMSE) between two FMP IRFs.
}
\examples{

set.seed(2342)
bmat <- sim_bmat(n_items = 2, k = 2, ncat = c(2, 5))$bmat

theta <- rnorm(500)
dat <- sim_data(bmat = bmat, theta = theta, maxncat = 5)

# k = 0
fmp0a <- fmp_1(dat = dat[, 1], k = 0, tsur = theta)
fmp0b <- fmp_1(dat = dat[, 2], k = 0, tsur = theta)

\donttest{
# k = 1
fmp1a <- fmp_1(dat = dat[, 1], k = 1, tsur = theta)
fmp1b <- fmp_1(dat = dat[, 2], k = 1, tsur = theta)
}

## compare estimated curves to the data-generating curve
rimse(fmp0a$bmat, bmat[1, -c(2:4)])
rimse(fmp0b$bmat, bmat[2, ], ncat = 5)

\donttest{
rimse(fmp1a$bmat, bmat[1, -c(2:4)])
rimse(fmp1b$bmat, bmat[2, ], ncat = 5)
}

}
\references{
Ramsay, J. O. (1991). Kernel smoothing approaches to
nonparametric item characteristic curve estimation. \emph{Psychometrika},
\emph{56}, 611--630. \doi{10.1007/BF02294494}
}
