% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate}
\alias{migrate}
\title{Range Estimation}
\usage{
migrate(file, header = TRUE, sep = ",", quote = "\"", dec = ".",
               fill = TRUE, comment.char = "", ...,
               data = NULL, settings = list(), method = "cmm",
               speed_control = "constant_speed", protein_met = 0)
}
\arguments{
\item{file}{The name of the file which the data are to read from}

\item{header}{Logical. If TRUE use first row as column headers}

\item{sep}{separator}

\item{quote}{The set of quoting characters. see read.csv}

\item{dec}{The character used in the file for decimal points}

\item{fill}{See read.csv}

\item{comment.char}{For more details see read.csv}

\item{...}{further arguments see read.csv}

\item{data}{A data frame}

\item{settings}{A list for re-defining constants. See details}

\item{method}{Methods for fuel management}

\item{speed_control}{One of two speed control methods. By default
\emph{constant_speed} is used. \emph{vvmp_constant} is the alternative.
The former holds the true airspeed constant while the latter holds the
ratio of true airspeed and minimum power speed constant}

\item{protein_met}{Percentage of energy attributed to protein and metabolism}
}
\value{
S3 class object with range estimates based on methods defined and
       settings
\itemize{
   \item data as a data frame
   \item range estimates (Km)
   \item fuel
   \item settings (named vector)
}
}
\description{
Practical range estimation of birds using methods in Pennycuick (1998)
and Pennycuick (2008).
}
\details{
The option *control takes the folowing arguments
\itemize{
   \item ppc: Profile power constant
   \item eFat: Energy content of fuel from fat
   \item eProtein: Energy content of protein
   \item g: Accelaration due to gravity
   \item mce: Mechanical conversion efficiency [0,1]
   \item ipf: Induced power factor
   \item vcp: Ventilation and circulation power
   \item airDensity: Air density at cruising altitude
   \item bdc: Body drag coefficient
   \item alpha: Basal metabolism factors in passerines and non passerines
   \item delta: Basal metabolism factors in passerines and non passerines
   alpha*bodyMass^delta
   \item invPower
   \item speedRatio: True air speed to minimum power speed ratio
   \item muscDensity: Density of the flight muscles.
   \item phr: Protein hydration ratio
}
}
\examples{
migrate(data = birds, settings = list(eFat = 3.89*10^7))
migrate(data = birds,  method = "cmm", settings = list(airDensity = 0.905))


}
\author{
Brian Masinde
}
