% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify.R
\name{fm_simplify_helper}
\alias{fm_simplify_helper}
\title{Recursive curve simplification.}
\usage{
fm_simplify_helper(loc, idx, eps = NULL, eps_rel = NULL)
}
\arguments{
\item{loc}{Coordinate matrix.}

\item{idx}{Index vector into \code{loc} specifying a polygonal curve.}

\item{eps}{Absolute straightness tolerance. Default \code{NULL}, no constraint.}

\item{eps_rel}{Relative straightness tolerance. Default \code{NULL}, no
constraint.}
}
\value{
An index vector into \code{loc} specifying the simplified polygonal
curve.
}
\description{
Helper from legacy \code{INLA::inla.simplify.curve()}

Attempts to simplify a polygonal curve by joining nearly colinear segments.

Uses a variation of the binary splitting Ramer-Douglas-Peucker algorithm,
with an ellipse of half-width \code{eps} ellipse instead of a rectangle, motivated
by prediction ellipse for Brownian bridge.
}
\details{
Variation of Ramer-Douglas-Peucker.
Uses width epsilon ellipse instead of rectangle,
motivated by prediction ellipse for Brownian bridge.
}
\examples{

theta <- seq(0, 2 * pi, length.out = 1000)
loc <- cbind(cos(theta), sin(theta))
idx <- fm_simplify_helper(loc = loc, idx = 1:nrow(loc), eps = 0.01)
print(c(nrow(loc), length(idx)))
plot(loc, type = "l")
lines(loc[idx, ], col = "red")
}
\seealso{
Other nonconvex inla legacy support: 
\code{\link{fm_nonconvex_hull_inla}()},
\code{\link{fm_segm_contour_helper}()}
}
\author{
Finn Lindgren \href{mailto:Finn.Lindgren@gmail.com}{Finn.Lindgren@gmail.com}
}
\concept{nonconvex inla legacy support}
\keyword{internal}
