% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg-methods.R
\name{plot.Reg}
\alias{plot.Reg}
\title{Plot a Regressor Object}
\usage{
\method{plot}{Reg}(
  x,
  grid = NULL,
  show_onsets = TRUE,
  onset_color = "red",
  onset_alpha = 0.5,
  precision = 0.33,
  ...
)
}
\arguments{
\item{x}{A `Reg` object created by `regressor()`.}

\item{grid}{Numeric vector of time points for evaluation. If NULL (default),
automatically generates a grid from 0 to max(onsets) + span with step 0.5s.}

\item{show_onsets}{Logical; if TRUE (default), show vertical dashed lines
at event onset times.}

\item{onset_color}{Color for onset lines. Default is "red".}

\item{onset_alpha}{Alpha transparency for onset lines. Default is 0.5.}

\item{precision}{Numeric sampling precision for HRF evaluation. Default is 0.33.}

\item{...}{Additional arguments passed to underlying plot functions.}
}
\value{
Invisibly returns a data frame with the time and response values.
}
\description{
Creates a visualization of a regressor object showing the predicted BOLD
response over time. Optionally displays event onsets as vertical lines.
}
\examples{
# Create and plot a simple regressor
reg <- regressor(onsets = c(10, 30, 50), hrf = HRF_SPMG1)
plot(reg)

# Plot with custom time grid
plot(reg, grid = seq(0, 80, by = 1))

# Plot without onset markers
plot(reg, show_onsets = FALSE
)
}
