% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/sampling_frame.R
\name{samples}
\alias{samples}
\alias{samples.sampling_frame}
\title{Get sample acquisition times}
\usage{
samples(x, ...)

\method{samples}{sampling_frame}(x, blockids = NULL, global = FALSE, ...)
}
\arguments{
\item{x}{Object describing the sampling grid}

\item{...}{Additional arguments passed to methods}

\item{blockids}{Integer vector of block identifiers to include (default: all blocks)}

\item{global}{Logical indicating whether to return global times (default: FALSE)}
}
\value{
Numeric vector of sample times
}
\description{
Generic function retrieving sampling times from a sampling frame or
related object.
}
\examples{
# Get sample times from a sampling frame
sframe <- sampling_frame(blocklens = c(100, 120), TR = 2)
samples(sframe, blockids = 1)  # First block only
samples(sframe, global = TRUE)  # All blocks, global timing
}
