% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{common.predict}
\alias{common.predict}
\title{Forecasting the factor-driven common component}
\usage{
common.predict(object, x, n.ahead = 1, fc.restricted = TRUE, r = c("ic", "er"))
}
\arguments{
\item{object}{\code{fnets} object}

\item{x}{input time series matrix, with each row representing a variable}

\item{n.ahead}{forecasting horizon}

\item{fc.restricted}{whether to forecast using a restricted or unrestricted, blockwise VAR representation of the common component}

\item{r}{number of restricted factors, or a string specifying the factor number selection method when \code{fc.restricted = TRUE};
 possible values are:
\describe{
   \item{\code{"ic"}}{ information criteria of Alessi, Barigozzi & Capasso (2010))}
   \item{\code{"er"}}{ eigenvalue ratio of Ahn & Horenstein (2013)}
}}
}
\value{
a list containing
\item{is}{ in-sample estimator of the common component (with each column representing a variable)}
\item{fc}{ forecasts of the common component for a given forecasting horizon \code{h} (with each column representing a variable)}
\item{r}{ restricted factor number}
\item{n.ahead}{ forecast horizon}
}
\description{
Produces forecasts of the common component
for a given forecasting horizon by estimating the best linear predictors
}
\examples{
\dontrun{
out <- fnets(data.unrestricted, q = NULL, var.order = 1, var.method = "lasso",
do.lrpc = FALSE, var.args = list(n.cores = 2))
cpre <- common.predict(out)
ipre <- idio.predict(out, cpre)
}
}
\references{
Ahn, S. C. & Horenstein, A. R. (2013) Eigenvalue ratio test for the number of factors. Econometrica, 81(3), 1203--1227.

Alessi, L., Barigozzi, M., and Capasso, M. (2010) Improved penalization for determining the number of factors in approximate factor models. Statistics & Probability Letters, 80(23-24):1806–1813.

Barigozzi, M., Cho, H. & Owens, D. (2024+) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. Journal of Business & Economic Statistics (to appear).

Forni, M., Hallin, M., Lippi, M. & Reichlin, L. (2005) The generalized dynamic factor model: one-sided estimation and forecasting. Journal of the American Statistical Association, 100(471), 830--840.

Forni, M., Hallin, M., Lippi, M. & Zaffaroni, P. (2017) Dynamic factor models with infinite-dimensional factor space: Asymptotic analysis. Journal of Econometrics, 199(1), 74--92.

Owens, D., Cho, H. & Barigozzi, M. (2024+) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. The R Journal (to appear).
}
\keyword{internal}
