% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{predict.fm}
\alias{predict.fm}
\title{Forecasting for factor models}
\usage{
\method{predict}{fm}(object, n.ahead = 1, fc.restricted = TRUE, r = c("ic", "er"), ...)
}
\arguments{
\item{object}{\code{fm} object}

\item{n.ahead}{forecasting horizon}

\item{fc.restricted}{if \code{fc.restricted = TRUE}, the forecast is generated under a restricted factor model}

\item{r}{number of static factors, or a string specifying the factor number selection method when \code{fc.restricted = TRUE};
possible values are:
\describe{
   \item{\code{"ic"}}{ information criteria of Alessi, Barigozzi & Capasso (2010)}
   \item{\code{"er"}}{ eigenvalue ratio of Ahn & Horenstein (2013) }
}}

\item{...}{not used}
}
\value{
a list containing
\item{is}{ in-sample predictions}
\item{forecast}{ forecasts for the given forecasting horizon}
\item{r}{ factor number}
}
\description{
Produces forecasts of the data input to \code{object} for a given forecasting horizon by
estimating the best linear predictors of the common component
}
\examples{
out <- fnets.factor.model(data.restricted, fm.restricted = TRUE)
pre <- predict(out)
}
\seealso{
\link[fnets]{fnets.factor.model}
}
