% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{field_validation}
\alias{field_validation}
\alias{field_rule}
\title{Field Validation for Fomantic UI}
\usage{
field_validation(id, ..., extra_params = NULL)

field_rule(rule, prompt = NULL, value = NULL)
}
\arguments{
\item{id}{HTML id of the field to be validated}

\item{...}{A series of \code{field_rule}s that will be applied to the field}

\item{extra_params}{A named list of extra parameters that can be added to the field validation. For example
\code{optional = TRUE} means the field will only be checked if non-empty}

\item{rule}{The type of rule to be applied. Valid rules are available in Details.}

\item{prompt}{Text to be displayed in the UI if the validation fails. Leave \code{NULL} if want to use default text.}

\item{value}{Certain fields require a value to check validation. Check Details if the \code{rule} requires a value.}
}
\value{
A structured list of the \code{field_rules} that can be recognised by \code{\link{form_validation}}.
}
\description{
A field validation assigns a series of rules that have been assigned to a particular input and checks, upon
the form submission, whether or not the input meets all specified criteria.
}
\details{
If it fails, then the field will be highlighted and the failures will either be specified as a message below the
field or a label. Once the failure(s) has been rectified, the highlighting will disappear.


The following \code{rules} are allowed:
\describe{
\item{\code{empty}}{A field is not empty}
\item{\code{checked}}{A checkbox field is checked}
\item{\code{email}}{A field is a valid e-mail address}
\item{\code{url}}{A field is a url}
\item{\code{integer}}{A field is an integer value or matches an integer range\code{*}}
\item{\code{decimal}}{A field must be a decimal number or matches a decimal range\code{*}}
\item{\code{number}}{A field is any number or matches a number range\code{*}}
\item{\code{regExp}}{Matches against a regular expression}
\item{\code{creditCard}}{A field is a valid credit card\code{**}}
\item{\code{contains}, \code{doesntContain}}{A field (doesn't) contain text (case insensitive)}
\item{\code{containsExactly}, \code{doesntContainExactly}}{A field (doesn't) contain text (case sensitive)}
\item{\code{is}, \code{not}}{A field is (not) a value (case insensitive)}
\item{\code{isExactly}, \code{notExactly}}{A field is (not) a value (case sensitive)}
\item{\code{minLength}, \code{exactLength}, \code{maxLength}}{A field is at least/exactly/at most a set length}
\item{\code{match}, \code{different}}{
A field should (not) match the value of another validation field. Use the field ID as the value
}
\item{\code{minCount}, \code{exactCount}, \code{maxCount}}{
A multiple select field contains at least/exactly/at most a set number of selections
}
}

\code{*} For ranges, include the parameter \code{value = "x..y"}
where \code{x} is the minimum value and \code{y} is the maximum value.
Leave either side blank to not have a lower/upper limit

\code{**} Include comma separated string of card providers if required e.g. \code{value = "visa,mastercard"}
}
\examples{
# E-mail validations
field_validation("email", field_rule("email"))

# Password validation
field_validation(
  "password",
  field_rule("empty"),
  field_rule("minLength", value = 8),
  field_rule("regExp", "Must contain at least one special character", "\\\\W")
)

}
\references{
\url{https://fomantic-ui.com/behaviors/form.html}
}
\seealso{
\code{\link{form_validation}}
}
