% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsffq_simple_functions.R
\name{macquotient}
\alias{macquotient}
\title{Food Quotient Based on Macronutrients}
\usage{
macquotient(row)
}
\arguments{
\item{row}{contains three components. p average daily grams of protein
consumed f average daily grams of fat consumed c/ average daily grams of
carbohydrates consumed}
}
\value{
one value per participant will be returned, representing the food
  quotient for the individual
}
\description{
The macquotient function calculates a food quotient for a participant based
on average daily protein, carbs, and fat consumed for an individual or a
group. In contrast to the quotient function, macquotient is able to generate
reliable average food quotients for a group of people rather than only
individual level. Group level estimates are recomended in some studies to
control for response bias.
}
\examples{
vec <- c(34.5,43, 212.4)
macquotient(vec)


vec1 <- c(34.5,43, 212.4)
vec2 <- c(40.1,52, 240)
df <- rbind(vec1, vec2)

df_results <- data.frame()
for (i in 1:nrow(df)) {
result <- macquotient(df[i,])
df_results <- rbind(df_results, result)
}


}
