% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsffq_simple_functions.R
\name{macros}
\alias{macros}
\title{Macronutrients}
\usage{
macros(row)
}
\arguments{
\item{row}{vector with 86 entries consisting of 2 components f1:f85 1-9,
representing different frequency factor responses from the hsffq. These will
be stored in columns 2-86 in the row you plug in A value representing
participant's age. This will be stored in column 1 of the input row}
}
\value{
the row or dataframe returned will have 3 entries, representing total
  daily amounts of protein, carbohydrates, and fat for each participant
}
\description{
The Macronutrients function takes the age of a participant and their responses
on the hsffq to generate estimates of the participant's total daily protein,
carbohydrate, and fat consumed for each food.
}
\examples{
 random_integers <- sample(1:9, 85, replace=TRUE)
vec <- c(6.2, random_integers)
grams(vec)

rquestionnaire <- function(n, n_food_questions = 85) {
  mat <- matrix(
    sample(1:9, n_food_questions*n, replace = TRUE),
    nrow = n, ncol = n_food_questions
  )
  df <- data.frame( age = round(runif(n, 2, 11), digits = 1) )
  cbind(df, as.data.frame(mat))
}
df <- rquestionnaire(3)

df_results <- data.frame()
for (i in 1:nrow(df)) {
result <- macros(df[i,])
df_results <- rbind(df_results, result)
}


}
