% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_species_names.R
\name{get_species_names}
\alias{get_species_names}
\title{Get species names from column names}
\usage{
get_species_names(data)
}
\arguments{
\item{data}{a \code{tibble} or a \code{data.frame}. One obtained by \verb{read_*_data()}
functions.}
}
\value{
A \code{character} vector of species names.
}
\description{
Gets species names from column names. This function is just an utility to
easily retrieve taxon names.
}
\examples{
# Import example dataset ----
file_name <- system.file(file.path("extdata", "FORCIS_net_sample.csv"),
                         package = "forcis")

net_data <- read.csv(file_name)

# Select a taxonomy ----
net_data <- select_taxonomy(net_data, taxonomy = "VT")

# Retrieve taxon names ----
get_species_names(net_data)
}
