% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pagination.R
\name{vert_pag_indices}
\alias{vert_pag_indices}
\title{Find column indices for vertical pagination}
\usage{
vert_pag_indices(
  mf,
  cpp = 40,
  colwidths = NULL,
  verbose = FALSE,
  rep_cols = 0L,
  fontspec,
  nosplitin = character(),
  round_type = obj_round_type(mf)
)
}
\arguments{
\item{mf}{(\code{MatrixPrintForm})\cr object to be paginated.}

\item{cpp}{(\code{numeric(1)})\cr number of characters per page (width).}

\item{colwidths}{(\code{numeric})\cr vector of column widths (in characters) for use in vertical pagination.}

\item{verbose}{(\code{flag})\cr whether additional informative messages about the search for
pagination breaks should be shown. Defaults to \code{FALSE}.}

\item{rep_cols}{(\code{numeric(1)})\cr number of \emph{columns} (not including row labels) to be repeated on every page.
Defaults to 0.}

\item{fontspec}{(\code{font_spec})\cr a font_spec object specifying the font information to use for
calculating string widths and heights, as returned by \code{\link[=font_spec]{font_spec()}}.}

\item{nosplitin}{(\code{character})\cr list of names of subtables where page breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{round_type}{(\code{string})\cr .
\cr The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
\cr iec, the default, and iec_mod performs rounding compliant with IEC 60559
(see notes in \code{\link[=round_fmt]{round_fmt()}}), while
sas performs nearest-value rounding consistent with rounding within SAS.\cr
In addition, the rounding of a negative number that rounds to zero will be presented as 0
(with the appropriate number of trailing zeros) for both \code{sas} and \code{iec_mod},
while for \code{iec}, it will be presented as -0 (with the appropriate number of trailing zeros).}
}
\value{
A \code{list} partitioning the vector of column indices into subsets for 1 or more horizontally paginated pages.
}
\description{
Find column indices for vertical pagination
}
\examples{
mf <- basic_matrix_form(df = mtcars)
colpaginds <- vert_pag_indices(mf, fontspec = font_spec())
lapply(colpaginds, function(j) mtcars[, j, drop = FALSE])

}
