\name{fracARMA}
\alias{fracARMA}
\title{Fractionally Integrated ARMA Model}
\description{
  This function applies fractional differencing and fits an ARMA model to time series data.
}
\usage{
fracARMA(ts, p, d, q, s)
}
\arguments{
  \item{ts}{A time series object (class `ts`).}
  \item{p}{The AR order.}
  \item{d}{The degree of fractional differencing.}
  \item{q}{The MA order.}
  \item{s}{The proportion of the data to be used for training.}
}
\value{
  A list containing the model summary, fitted values, and forecasted results.
}
\references{
  The `forecast` and `fracdiff` packages are used for model fitting and fractional differencing.
}
\examples{
  ts_data <- ts(rnorm(100))
  result <- fracARMA(ts_data, p = 1, d = 0.3, q = 1, s = 0.8)
}
