% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracdist.R
\name{check_fracdist_params}
\alias{check_fracdist_params}
\title{Verify that fracdist parameters are valid parameter values}
\usage{
check_fracdist_params(fracdist_params)
}
\arguments{
\item{fracdist_params}{a list that may have the following elements:
\itemize{
\item \code{iq} An integer scalar rank parameter for the test, from 1 through 12.
This is often the difference in cointegration rank.
\item \code{iscon} An indicator that there is a constant intercept
term in the model.
\item \code{clevel} The numeric scalar level of significance.
\item \code{bb} The fractional integration parameter, which can take on values
between 0.0 and 2.0.
}}
}
\value{
No return value when checks pass, otherwise execution halts
and an error message is printed.
}
\description{
This is a helper function for error handling in the fracdist package.
It is not intended to be used externally but might help diagnose
error messages from improperly chosen arguments.
}
\examples{
# Test with iscon = 7 to see error message:
check_fracdist_params(list(iq = 2, iscon = 1))
# Test with iq = 13 to see error message:
check_fracdist_params(list(iq = 12, iscon = 1))
# Test with bb = -0.5 to see error message:
check_fracdist_params(list(iq = 12, iscon = 1, bb = 0.75))
# Test with bb = 2.5 to see error message:
check_fracdist_params(list(iq = 12, iscon = 1, bb = 1.5))
# Test with clevel = 2.5 to see error message:
check_fracdist_params(list(iq = 1, iscon = 1, clevel = 0.05))
}
\references{
James G. MacKinnon and Morten \enc{Ø}{O}rregaard Nielsen,
"Numerical Distribution Functions of Fractional Unit Root and Cointegration Tests,"
\emph{Journal of Applied Econometrics}, Vol. 29, No. 1, 2014, pp.161-171.
}
