#' Simulated High-dimensional Clustered data
#'
#' This data include 50 clusters with 4 objects, a total of 200 events are recorded.
#' 500 covariates can be used for model fitting. The data is generated from a
#' gamma frailty model with coefficients (5,5,5,5,...,0) and frailty variance 1.
#'
#' @docType data
#' @usage data(hdCLdata)
#' @keywords datasets
#' @examples
#' data(hdCLdata)
"hdCLdata"

#' Simulated Clustered data
#'
#' This data include 50 clusters with 10 objects, a total of 100 events are recorded.
#' 30 temporal covariates can be used for model fitting. The data is generated from a
#' gamma frailty model with coefficients (1,2,3,4,0,...,0) and frailty variance 1.
#'
#' @docType data
#' @usage data(simdataCL)
#' @keywords datasets
#' @examples
#' data(simdataCL)
"simdataCL"


#' Simulated Multiple Event data
#'
#' This data include 50 individuals with 2 events, a total of 100 events are recorded.
#' 30 temporal covariates can be used for model fitting. The data is generated from a
#' gamma frailty model with coefficients (1,2,3,4,0,...,0) and frailty variance 1.
#'
#' @docType data
#' @usage data(simdataME)
#' @keywords datasets
#' @examples
#' data(simdataME)
"simdataME"


#' Simulated Recurrent Event data
#'
#' This data include 50 individuals with recurrent observation of events, a total of 706 events are recorded.
#' 30 temporal covariates can be used for model fitting. The data is generated from a
#' gamma frailty model with coefficients (1,2,3,4,0,...,0) and frailty variance 1.
#'
#' @docType data
#' @usage data(simdataRE)
#' @keywords datasets
#' @examples
#' data(simdataRE)
"simdataRE"