% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHelp.R
\docType{data}
\name{CPRSKbmtcrr}
\alias{CPRSKbmtcrr}
\title{Transformed Bone Marrow Transplant Data for Competing Risks}
\format{
A data frame with 177 observations and the following columns:
  \describe{
    \item{id}{Unique subject identification number.}
    \item{Sex}{Gender of the individual (Factor: Male, Female).}
    \item{D}{Disease type: ALL or AML (Factor: ALL, AML).}
    \item{Phase}{Phase at transplant (Factor: Relapse, CR1, CR2, CR3).}
    \item{Age}{Age in years at transplant (start of follow-up).}
    \item{Status}{Status indicator: 0 = censored, 1 = relapse, 2 = competing event.}
    \item{Source}{Source of stem cells (Factor: BM+PB, PB).}
    \item{ftime}{Original failure time in months since transplant.}
    \item{group}{Example grouping variable (numeric, derived from id mod 10 + 1).}
    \item{observed_time}{Time in years since birth (Age + ftime/12) representing the
     time of event or censoring relative to birth as origin.}
}
}
\source{
Derived from the \code{bmtcrr} dataset available in the \code{casebase} package.
}
\usage{
data(CPRSKbmtcrr)
}
\description{
A dataset derived from the \code{bmtcrr} data (originally from the
\code{casebase} package). This version adds unique subject IDs, an example
grouping variable, and calculates an `observed_time` based on age at transplant
plus follow-up time in years, setting age 0 as the origin. It's prepared
for competing risks analyses, potentially with frailties or left truncation.
}
\details{
This dataset was created by taking the original \code{bmtcrr} data from the
\code{casebase} package and applying the following transformations:
\enumerate{
  \item Added a unique subject identifier \code{id}.
  \item Added an example grouping variable \code{group} based on \code{id}.
  \item Calculated \code{observed_time = Age + ftime/12} to represent the
      subject's age at event or censoring, potentially for use with left
      truncation at \code{Age}.
}
The primary event is typically relapse (Status=1), with death without relapse
(Status=2) as a competing event. Censoring is Status=0. Note that the time
scale for \code{observed_time} is years since birth.
}
\references{
Scrucca L, Santucci A, Aversa F. Competing risk analysis using R:
  an easy guide for clinicians. \emph{Bone Marrow Transplant}. 2007 Aug;40(4):381-7.
  doi:10.1038/sj.bmt.1705727.
}
\seealso{
\code{bmtcrr}. The \code{casebase} package.
}
\keyword{datasets}
