% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jointRecCompet.R
\name{plot.jointRecCompet}
\alias{plot.jointRecCompet}
\title{Plot Method for a joint competing risk model with one recurrent event and 
two terminal events.}
\usage{
\method{plot}{jointRecCompet}(x, event = "All", type.plot = "Hazard",
conf.bands = FALSE, pos.legend = "topright", cex.legend = 0.7, ylim, main,
color1="red", color2="blue", colorEnd="green", median=TRUE, Xlab = "Time", 
Ylab = "Hazard function", ...)
}
\arguments{
\item{x}{A joint competing risk model, i.e. an object of class
\code{jointRecCompet} (output from calling \code{jointRecCompet} function).}

\item{event}{a character string specifying the type of outcome. Possible
value are "Recurrent", "Terminal1",  "Terminal2", or "All". The default is
"All".}

\item{type.plot}{a character string specifying the type of curve. Possible
value are "Hazard", or "Survival". The default is "Hazard". Only the first
words are required, e.g "Haz", "Su"}

\item{conf.bands}{logical value. Determines whether confidence intervals
will be plotted. The default is to do so.}

\item{pos.legend}{The location of the legend can be specified by setting
this argument to a single keyword from the list '"bottomright"', '"bottom"',
'"bottomleft"', '"left"', '"topleft"', '"top"', '"topright"', '"right"' and
'"center"'. The default is '"topright"'}

\item{cex.legend}{character expansion factor *relative* to current
'par("cex")'. Default is 0.7}

\item{ylim}{y-axis limits}

\item{main}{plot title}

\item{color1}{curve color for recurrent event of type 1 (integer or color
name in quotation marks)}

\item{color2}{curve color for recurrent event of type 2 (integer or color
name in quotation marks)}

\item{colorEnd}{curve color for terminal event (integer or color name in
quotation marks)}

\item{median}{Logical value. Determines whether survival median will be plotted. Default is TRUE.}

\item{Xlab}{Label of x-axis. Default is '"Time"'}

\item{Ylab}{Label of y-axis. Default is '"Hazard function"'}

\item{\dots}{Other graphical parameters}
}
\value{
Print a plot of the baseline survival or hazard functions for each
type of event or both with the confidence intervals or not (conf.bands
argument)
}
\description{
Plots of estimated baseline survival and hazard functions of joint competing 
recurrent model (output from an object of class 'jointRecCompet') 
for each type of event (recurrent and the two terminal events). 
Confidence intervals are allowed.
}
\seealso{
\code{\link{jointRecCompet}}
}
\keyword{methods}
