% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{dot-list_columns}
\alias{dot-list_columns}
\alias{.list_columns}
\alias{.list_columns.SQLiteConnection}
\alias{.list_columns.PqConnection}
\alias{.list_columns.MariaDBConnection}
\alias{.list_columns.Microsoft SQL Server}
\alias{.list_columns.duckdb_connection}
\alias{.list_columns.default}
\title{List all columns in a table (S3 generic)}
\usage{
.list_columns(conn, table_name)

\method{.list_columns}{SQLiteConnection}(conn, table_name)

\method{.list_columns}{PqConnection}(conn, table_name)

\method{.list_columns}{MariaDBConnection}(conn, table_name)

\method{.list_columns}{`Microsoft SQL Server`}(conn, table_name)

\method{.list_columns}{duckdb_connection}(conn, table_name)

\method{.list_columns}{default}(conn, table_name)
}
\arguments{
\item{conn}{Database connection (DBIConnection)}

\item{table_name}{Character. Name of the table}
}
\value{
Character vector of column names
}
\description{
Cross-database method to list all columns in a table.
Uses database-specific introspection methods via S3 dispatch.
}
\section{Functions}{
\itemize{
\item \code{.list_columns(SQLiteConnection)}: SQLite implementation using PRAGMA

\item \code{.list_columns(PqConnection)}: PostgreSQL implementation using information_schema

\item \code{.list_columns(MariaDBConnection)}: MySQL/MariaDB implementation using information_schema

\item \code{.list_columns(`Microsoft SQL Server`)}: SQL Server implementation using information_schema

\item \code{.list_columns(duckdb_connection)}: DuckDB implementation using information_schema

\item \code{.list_columns(default)}: Default implementation using information_schema

}}
\examples{
\donttest{
if (FALSE) {
conn <- connection_get("my_db")
columns <- .list_columns(conn, "users")
DBI::dbDisconnect(conn)
}
}
}
\keyword{internal}
