% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.R
\name{publish_dir}
\alias{publish_dir}
\title{Publish a directory to S3}
\usage{
publish_dir(
  dir,
  dest = NULL,
  connection = NULL,
  pattern = NULL,
  recursive = TRUE
)
}
\arguments{
\item{dir}{Character. Local directory path.}

\item{dest}{Character or NULL. Destination prefix in S3. If NULL, uses
the directory name.}

\item{connection}{Character or NULL. S3 connection name, or NULL for default.}

\item{pattern}{Character or NULL. Optional regex pattern to filter files.}

\item{recursive}{Logical. Whether to include subdirectories. Default TRUE.}
}
\value{
Character vector. Public URLs of uploaded files.
}
\description{
Recursively uploads all files in a directory to S3.
}
\examples{
\donttest{
if (FALSE) {
# Upload entire directory
publish_dir("outputs/dashboard/")

# Upload to specific location
publish_dir("outputs/dashboard/", dest = "dashboards/v2/")

# Upload only HTML files
publish_dir("outputs/", pattern = "\\\\.html$")
}
}
}
