% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetFVar.R
\name{NetFVar}
\alias{NetFVar}
\title{Fréchet Variance for Networks}
\usage{
NetFVar(Ly = NULL)
}
\arguments{
\item{Ly}{A list (length n) of m by m matrices or a m by m by n array where
\code{Ly[, , i]} contains an m by m matrix, which can be either graph 
Laplacian matrices or covariance matrices or correlation matrices.}
}
\value{
A list containing the following fields:
\item{NetFVar}{A scalar holding the Fréchet variance.}
\item{NetFMean}{A matrix holding the Fréchet mean.}
}
\description{
Obtain Fréchet variance for graph Laplacian matrices, 
  covariance matrices, or correlation matrices 
  with respect to the Frobenius distance.
}
\examples{
set.seed(1)
n <- 100
U <- pracma::randortho(10)
Ly <- lapply(1:n, function(i) {
  U \%*\% diag(rexp(10, (1:10)/2)) \%*\% t(U)
})
res <- NetFVar(Ly)
res$NetFVar
}
