% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pol2car.R
\name{pol2car}
\alias{pol2car}
\title{Transform polar to Cartesian coordinates}
\usage{
pol2car(p)
}
\arguments{
\item{p}{A vector of length \eqn{d} \eqn{(d\ge 2)} with the first element being the radius and the others being the angles,
where \code{p[2]} takes values in \eqn{[0,2\pi]} and \code{p[i]} takes values in \eqn{[-\pi/2,\pi/2]}, for all \eqn{i>2} if any.}
}
\value{
A vector of length \eqn{d} holding the corresponding Cartesian coordinates 
\deqn{\left(r\prod_{i=1}^{d-1}\cos\theta_i, r\sin\theta_1\prod_{i=2}^{d-1}\cos\theta_i, r\sin\theta_2\prod_{i=3}^{d-1}\cos\theta_i,\dots, r\sin\theta_{d-2}\cos\theta_{d-1}, r\sin\theta_{d-1}\right),}
where \eqn{r} is given by \code{p[1]} and \eqn{\theta_i} is given by \code{p[i+1]} for \eqn{i=1,\dots,d-1}.
}
\description{
Transform polar to Cartesian coordinates
}
\examples{
pol2car(c(1, 0, pi/4)) # should equal c(1,0,1)/sqrt(2)
pol2car(c(1, pi, 0)) # should equal c(-1,0,0)
}
