% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptehd.R
\name{ptehd}
\alias{ptehd}
\title{Proportion of treatment effect explained by high-dimensional surrogates}
\usage{
ptehd(Yt, Yc, St, Sc, lambda_range = c(0, 1))
}
\arguments{
\item{Yt}{The n-dmensional outcome vector in the treatment group.}

\item{Yc}{The n-dmensional outcome vector in the control group.}

\item{St}{The n x p matrix of surrogates in the treatment group.}

\item{Sc}{The n x p matrix of surrogates in the treatment group.}

\item{lambda_range}{Min and max of range of range of tuning parameter to use during the constrained l1 optimization step.}
}
\value{
A list with components:
\item{est_id}{Estimate of indirect effect, defined as \eqn{\int E(Y | S = s, Z = 1) dF(s | Z = 1) - \int E(Y | S = s, Z = 0) dF(s | Z = 0)}}
\item{sd_id}{Standard deviation of indirect effect estimate}
\item{est_total}{Estimate of total effect}
\item{sd_total}{Standard deviation of total effect estimate}
\item{V}{Covariance matrix of (est_id, est_total)}
\item{est_R}{Estimate of proportion of treatment effect explained by surrogates}
\item{sd_R}{Standard deviation of proportion estimate}
\item{lambda_used}{lambda used during optimization}
}
\description{
Estimates the proportion of the treatment effect explained by the indirect effect via high-dimensional surrogates.
}
\examples{
n = 10
St = replicate(n, rnorm(20, mean = 1))
Sc = replicate(n, rnorm(20))
Yt = 1 + rowSums(St) / 2 + rnorm(n)
Yc = rowSums(Sc) / 3 + rnorm(n)
# Requires installation of mosek to run
\dontrun{
out = ptehd(Yt, Yc, St, Sc)
}
}
\author{
Ruixuan Zhou
}
