% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslor.R
\name{fslor}
\alias{fslor}
\alias{fsl_or}
\title{Perform OR/Union operation on Images using FSL}
\usage{
fslor(
  file,
  file2,
  outfile = NULL,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  ...
)

fsl_or(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)
}
\arguments{
\item{file}{(character) input image}

\item{file2}{(character) image to be unioned}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented 
when read in?
Passed to \code{\link[neurobase]{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{...}{additional arguments passed to \code{\link[neurobase]{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslmaths file -add file2 -bin}
after binarizing \code{file} and \code{file2} using
 \code{\link{fslbin}}.
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
