% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcompose.R
\name{fcompose}
\alias{fcompose}
\title{Compose multiple functions}
\usage{
fcompose(...)
}
\arguments{
\item{...}{Functions to compose. Each must take a single argument and return an object
compatible with the next function in the chain.}
}
\value{
A new function equivalent to nested application of the input functions.
}
\description{
Create a new function by composing several functions, applied from right to left.
Equivalent to `f1(f2(f3(...)))`.
}
\examples{
square <- function(x) x^2
add1 <- function(x) x + 1

f <- fcompose(sqrt, square, add1)  # => sqrt(square(x + 1))
f(4)  # => sqrt((4 + 1)^2) = sqrt(25) = 5

# More compact
fcompose(log, exp)(2)  # log(exp(2)) = 2

}
