% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getKFunction.R
\name{getKFunction}
\alias{getKFunction}
\title{Get K function}
\usage{
getKFunction(
  data,
  agents,
  unit,
  replicate = NULL,
  rCheckVals = NULL,
  xRange = NULL,
  yRange = NULL,
  edgeCorrection = "isotropic"
)
}
\arguments{
\item{data}{Dataframe with column titles for at least x, y, agents,
and unit. For consistency (and avoiding errors), use that order.
Additionally, replicate can be added.}

\item{agents}{Two value vector indicating the two agents to use for the K
function, the first to the second. These should be in the unit column.}

\item{unit}{String of the column name in data indicating a unit or base
thing. Note this unit may have replicates.}

\item{replicate}{(Optional) String of the column name in data indicating the
unique replicates, or repeated measures.}

\item{rCheckVals}{(Optional) Numeric vector indicating the radius to check.
Note, if note specified, this could take a lot of memory, particularly
with many units and replicates.}

\item{xRange, yRange}{(Optional) Two value numeric vector indicating the min
and max x / y values. Note this is re-used for all images. The default just
takes the min and max from each image. This allows different sized images,
but the edges are defined by some agent location.}

\item{edgeCorrection}{(Optional) String indicating type of edgeCorrection(s)
to apply when computing the K functions. Options include: "border",
"bord.modif", "isotropic", "Ripley", "translate", "translation", "periodic",
"none", "best" or "all" selects all options.}
}
\value{
data.frame with the first column being the checked radius and the
remaining columns relating to the K function for each unit at those
points. If a K function could not be computed, perhaps due to lack of
data, an NA is returned for the K function.
}
\description{
This function computes the K function between the two agents for each unit,
potentially averaging over replicates, or repeated measures.
}
\examples{
KFunction <- getKFunction(
  agents = c("B", "Tumor"), unit = "Person",
  data = TNBC_pheno[TNBC_pheno$Person == 1, -1],
  rCheckVals = seq(0, 50, 1),
  edgeCorrection = "isotropic"
)
}
