% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{fix_element_size}
\alias{fix_element_size}
\title{Configure Fix Element Size Behavior}
\usage{
fix_element_size(
  key = "fix-element-size",
  enable = TRUE,
  reset = FALSE,
  state = "",
  node = NULL,
  nodeFilter = JS("() => true"),
  edge = list(list(shape = "key", fields = c("lineWidth")), list(shape = "halo", fields =
    c("lineWidth")), list(shape = "label", fields = c("fontSize"))),
  edgeFilter = JS("() => true"),
  combo = NULL,
  comboFilter = JS("() => true"),
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior, used for subsequent operations
(string, default: "fix-element-size").}

\item{enable}{Whether to enable this interaction (boolean or JS function, default: TRUE).}

\item{reset}{Whether to restore style when elements are redrawn (boolean, default: FALSE).}

\item{state}{Specify the state of elements to fix size (string, default: "")}

\item{node}{Node configuration item(s) to define which attributes maintain fixed
size (list or array of lists, default: NULL).}

\item{nodeFilter}{Node filter to determine which nodes maintain fixed size
(JS function, default: returns TRUE for all nodes).}

\item{edge}{Edge configuration item(s) to define which attributes maintain fixed size
(list or array of lists, default: predefined list).}

\item{edgeFilter}{Edge filter to determine which edges maintain fixed size
(JS function, default: returns TRUE for all edges).}

\item{combo}{Combo configuration item(s) to define which attributes maintain fixed size
(list or array of lists, default: NULL).}

\item{comboFilter}{Combo filter to determine which combos maintain fixed size
(JS function, default: returns TRUE for all combos).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/fix-element-size}.}
}
\value{
A list with the configuration settings for the fix-element-size behavior.
}
\description{
Creates a configuration object for the fix-element-size behavior in G6.
This allows maintaining fixed visual sizes for elements during zoom operations.
}
\examples{
# Basic configuration
config <- fix_element_size()

# Custom configuration with filters and specific shape configurations
config <- fix_element_size(
  key = "my-fix-size-behavior",
  reset = TRUE,
  state = "active",
  node = list(
    list(shape = "circle", fields = c("r", "lineWidth")),
    list(shape = "label", fields = c("fontSize"))
  ),
  nodeFilter = JS("(node) => node.type === 'important'"),
  edge = list(shape = "line", fields = c("lineWidth", "lineDash")),
  edgeFilter = JS("(edge) => edge.weight > 5")
)
}
