% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpt_pot_gather.R
\name{compileCPT}
\alias{compileCPT}
\alias{compilePOT}
\title{Compile conditional probability tables / cliques potentials.}
\usage{
compileCPT(x, ..., forceCheck = TRUE)

compilePOT(x, ..., forceCheck = TRUE)
}
\arguments{
\item{x}{To \code{compileCPT} x is a list of conditional
probability tables; to \code{compilePOT}, x is a list of clique
potentials.}

\item{...}{Additional arguments; currently not used.}

\item{forceCheck}{Controls if consistency checks of the probability
tables should be made.}
}
\value{
A list with a class attribute.
}
\description{
Compile conditional probability tables / cliques
potentials as a preprocessing step for creating a graphical
independence network
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{* `compileCPT` is relevant for turning a collection of
cptable's into an object from which a network can be built. For
example, when specification of a cpt is made with cptable then
the levels of the node is given but not the levels of the
parents. `compileCPT` checks that the levels of variables in
the cpt's are consistent and also that the specifications
define a dag.

* `compilePOT` is not of direct relevance for the
user for the moment. However, the elements of the input should
be arrays which define a chordal undirected graph and the
arrays should, if multiplied, form a valid probability density.
}\if{html}{\out{</div>}}
}
\examples{

example("example_chest_cpt")
x <- compile_cpt(chest_cpt)
class(x)
grain(x)

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{https://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{extract_cpt}}, \code{\link{extract_pot}}, \code{\link{extract_marg}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\concept{old_names}
