% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{sid}
\alias{sid}
\title{Structural Identification Distance between two DAG adjacency matrices}
\usage{
sid(g_true, g_guess, edge_direction)
}
\arguments{
\item{g_true}{Adjacency matrix of the true directed acyclic graph}

\item{g_guess}{Adjacency matrix of the guess directed acyclic graph}

\item{edge_direction}{either "from row to column" or "from column to row"}
}
\value{
2-element vector of type double \cr c(normalized error in [0,1], total number of errors)
}
\description{
Computes the structural intervention distance (SID),
between the true \code{g_true} DAG and an estimated \code{g_guess} DAG.
}
\details{
Since the Parent-AID reduces to the SID in the special case of DAG inputs
and is efficiently implemented using reachability algorithms,
it offers a faster way to calculate the SID;
see also Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616}.
The example below can be compared to

\if{html}{\out{<div class="sourceCode R">}}\preformatted{library("SID")
system.time(structIntervDist(random_dag(20), random_dag(20)))
}\if{html}{\out{</div>}}

For details see Henckel, Würtzen, Weichwald (2024) \doi{doi:10.48550/arXiv.2402.08616} \cr
The source code is available at \href{https://github.com/CausalDisco/gadjid}{github.com/CausalDisco/gadjid}

Graph inputs are accepted as adjacency matrices of type double.
An adjacency matrix for a DAG may only contain 0s and 1s.
DAG inputs are validated for acyclicity.

If \code{edge_direction="from row to column"}, then
a \code{1} in row \code{r} and column \code{c} codes a directed edge ‘r → c’;
if \code{edge_direction="from column to row"}, then
a \code{1} in row \code{r} and column \code{c} codes a directed edge ‘c → r’.
}
\examples{
random_dag <- function(n, p=0.1) {
    P <- sample(n)
    m <- matrix(0, n, n)
    m[upper.tri(m)] <- rbinom(n*(n-1)/2, 1, p)
    m[P, P]
}

system.time(sid(random_dag(400), random_dag(400), "from row to column"))

}
\references{
L Henckel, T Würtzen, S Weichwald.
"Adjustment Identification Distance: A gadjid for Causal Structure Learning."
Proceedings of the 40th Conference on Uncertainty in Artificial Intelligence (UAI), 2024.
\doi{doi:10.48550/arXiv.2402.08616}

J Peters,P Bühlmann.
"Structural intervention distance for evaluating causal graphs."
Neural Compututation 27(3), 771–799, 2015.
\doi{doi:10.1162/NECO_a_00708}
}
