#' Wind turbine operational data
#'
#' A dataset containing the measurements of wind-related and other environmental
#' variables as well as the actual power output measurements of an operating
#' wind turbine.
#'
#' @format A data frame with 1000 rows and 7 variables: \itemize{ \item \code{time}:
#'   timestamp, \item \code{V}: wind speed (\eqn{m/s}), \item \code{D}: wind
#'   direction (degree), \item \code{rho}: air density (\eqn{kg/m^3}), \item
#'   \code{I}: turbulence intensity, \item \code{Sb}: below-hub wind shear, \item
#'   \code{y}: power output (\eqn{kW}). }
#'
#' @note This dataset is generated by using \code{windpw} dataset in \code{kernplus}
#'   package. Timestamp has been added (randomly), and the power output of
#'   \code{windpw} dataset has been arbitrarily muliplied by 10 to represent
#'   \eqn{kW} values.
#'
"wtg"
