% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.R
\name{family.galamm}
\alias{family.galamm}
\title{Extract family or families from fitted galamm}
\usage{
\method{family}{galamm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{galamm} returned from
\code{\link{galamm}}.}

\item{...}{Optional arguments passed on to other methods. Currently not used.}
}
\value{
A list of family objects.
}
\description{
This function returns a list of families for an object of class
\code{galamm}, returned from \code{\link{galamm}}.
}
\examples{
# Mixed response model
loading_matrix <- matrix(c(1, NA), ncol = 1)
families <- gfam(list(gaussian, binomial))

mixed_resp <- galamm(
  formula = y ~ x + (0 + level | id),
  data = mresp,
  family = families,
  load_var = "itemgroup",
  lambda = loading_matrix,
  factor = "level"
)

# This model has two family objects
family(mixed_resp)

}
\seealso{
\code{\link[=galamm]{galamm()}}

Other details of model fit: 
\code{\link{VarCorr}()},
\code{\link{appraise.galamm}()},
\code{\link{coef.galamm}()},
\code{\link{confint.galamm}()},
\code{\link{derivatives.galamm}()},
\code{\link{deviance.galamm}()},
\code{\link{factor_loadings.galamm}()},
\code{\link{fitted.galamm}()},
\code{\link{fixef}()},
\code{\link{formula.galamm}()},
\code{\link{llikAIC}()},
\code{\link{logLik.galamm}()},
\code{\link{model.frame.galamm}()},
\code{\link{nobs.galamm}()},
\code{\link{predict.galamm}()},
\code{\link{print.VarCorr.galamm}()},
\code{\link{ranef.galamm}()},
\code{\link{residuals.galamm}()},
\code{\link{response}()},
\code{\link{sigma.galamm}()},
\code{\link{vcov.galamm}()}
}
\concept{details of model fit}
