% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqmath.R
\name{qqmath.galamm}
\alias{qqmath.galamm}
\alias{qqmath}
\title{Quantile-quantile plots for galamm objects}
\usage{
\method{qqmath}{galamm}(x, data = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{galamm}, returned from
\code{\link{galamm}}.}

\item{data}{Ignored. Required for S3 method compatibility.}

\item{...}{Optional parameters passed on to other methods. Currently not
used.}
}
\value{
A quantile-quantile plot.
}
\description{
Quantile-quantile plots for galamm objects
}
\examples{
## Linear mixed model example from lme4
data("sleepstudy", package = "lme4")
mod <- galamm(Reaction ~ Days + (Days | Subject), data = sleepstudy)
qqmath(mod)

}
\seealso{
Other diagnostics: 
\code{\link{plot.galamm}()}
}
\author{
This function is derived from \code{lme4:::qqmath.merMod}, written by
Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker.
}
\concept{diagnostics}
