% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{clermont_2024}
\alias{clermont_2024}
\title{Clermont Reference Data 2024}
\format{
A \code{\link{data.frame}} with tabulated data and conversion factor reference.
}
\source{
Adamiec, G. & Aitken, M.J. (1998).
Dose-rate conversion factors: update. \emph{Ancient TL}, 16, p. 37–50.

Cresswell, A.J., Carter, J. & Sanderson, D.C.W. (2018). Dose rate
conversion parameters: Assessment of nuclear data.
\emph{Radiation Measurements}, 120, p. 195–201.

Guérin, G., Mercier, N. & Adamiec, G. (2011). Dose-Rate Conversion Factors:
Update. \emph{Ancient TL}, 29(1), p. 5-8.

Liritzis, I., Stamoulis, K., Papachristodoulou, C. & Ioannides, K. (2013).
A re-evaluation of radiation dose-rate conversion factors.
\emph{Mediterranean Archaeology and Archaeometry}, 12, p. 1–15.

Miallier, D., Guérin, G., Mercier, N., Pilleyre, T. & Sanzelle, S.
(2009). The Clermont Radiometric Reference Rocks: A Convenient Tool
for Dosimetric Purposes. \emph{Ancient TL}, 27(2), p. 37-44.
}
\usage{
data("clermont_2024")
}
\description{
An updated version for the \code{clermont} dataset with additional columns
for the applied dose rate conversion factors and their reference. The dataset
also contains gamma dose rate values and uncertainties for different published
conversion factors. Please note that the values for the conversion factors
applied in the original \code{clermont} dataset differ slightly due to rounding
errors.
}
\seealso{
Other datasets: 
\code{\link{AIX_NaI_1}},
\code{\link{BDX_LaBr_1}},
\code{\link{clermont}}
}
\concept{datasets}
\keyword{datasets}
