% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtlClassifier.R
\name{qtlClassifier}
\alias{qtlClassifier}
\title{A QTL cis/trans classifier}
\usage{
qtlClassifier(geneSNP, SNPPos, genePos, radius)
}
\arguments{
\item{geneSNP}{data.frame with columns on gene, SNP and biomarker (e.g., expression, protein).}

\item{SNPPos}{data.frame containing SNP, chromosome and position.}

\item{genePos}{data.frame containing gene, chromosome, start and end positions.}

\item{radius}{flanking distance.}
}
\value{
It returns a geneSNP-prefixed data.frame with the following columns:
\itemize{
\item geneChrom gene chromosome.
\item geneStart gene start.
\item geneEnd gene end.
\item SNPChrom pQTL chromosome.
\item SNPPos pQTL position.
\item Type cis/trans labels.
}
}
\description{
A QTL cis/trans classifier
}
\details{
The function obtains QTL (simply called SNP here) cis/trans classification based on gene positions.
}
\note{
This is adapted from iBMQ/eqtlClassifier as an xQTL (x=e, p, me, ...) classifier.
}
\examples{
\dontrun{
  merged <- read.delim("INF1.merge",as.is=TRUE)
  hits <- merge(merged[c("CHR","POS","MarkerName","prot","log10p")],
                inf1[c("prot","uniprot")],by="prot")
  names(hits) <- c("prot","Chr","bp","SNP","log10p","uniprot")

  options(width=200)
  geneSNP <- merge(hits[c("prot","SNP","log10p")],
                   inf1[c("prot","gene")],by="prot")[c("gene","SNP","prot","log10p")]
  SNPPos <- hits[c("SNP","Chr","bp")]
  genePos <- inf1[c("gene","chr","start","end")]
  cvt <- qtlClassifier(geneSNP,SNPPos,genePos,1e6)
  cvt
  cistrans <- cis.vs.trans.classification(hits,inf1,"uniprot")
  cis.vs.trans <- with(cistrans,data)
  cistrans.check <- merge(cvt[c("gene","SNP","Type")],cis.vs.trans[c("p.gene","SNP","cis.trans")],
                          by.x=c("gene","SNP"),by.y=c("p.gene","SNP"))
  with(cistrans.check,table(Type,cis.trans))
}

}
\seealso{
\code{\link{cis.vs.trans.classification}}
}
