% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_points.R
\name{thin_points}
\alias{thin_points}
\title{Spatial Correction - Spatially thin records}
\usage{
thin_points(
  df,
  accepted.name = NA,
  distance = 5,
  reps = 100,
  latitude = "latitude",
  longitude = "longitude"
)
}
\arguments{
\item{df}{Data frame of occurrence records.}

\item{accepted.name}{Accepted name of your species. This argument is not required
if the data frame already contains an accepted_name column.}

\item{distance}{Default = 5. Distance in km to separate records.}

\item{reps}{Default = 100. Number of times to perform thinning algorithm.}

\item{latitude}{Default = "latitude". The name of the \href{http://rs.tdwg.org/dwc/terms/decimalLatitude}{latitude} column in the data frame.}

\item{longitude}{Default = "longitude". The name of the \href{http://rs.tdwg.org/dwc/terms/decimalLongitude}{longitude} column in the data frame.}
}
\value{
df is a data frame with the cleaned data.
Information about the columns in the returned data frame can be found in the documentation for \code{gators_download()}.
}
\description{
The \code{thin_points} function returns records based on coordinate thinning based on a minimum nearest neighbor distance approach.
}
\details{
This function is a wrapper for spatial thinning using the spThin package (Aiello-Lammens et al., 2015)
In summary, the thinning algorithm provided by spThin calculates the pairwise distances between data points,
then randomly samples a single point from all points less than or equal to the set minimum nearest neighbor distance.
This process is repeated until the pairwise distances among points do not fall below the minimum nearest neighbor distance.
}
\examples{
thinned_data <- thin_points(data, accepted.name = "Galax urceolata")

}
