% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dynamic_feeds.R
\name{get_free_bike_status}
\alias{get_free_bike_status}
\title{Grab the free_bike_status feed.}
\usage{
get_free_bike_status(
  city,
  directory = NULL,
  file = "free_bike_status.rds",
  output = NULL
)
}
\arguments{
\item{city}{A character string that can be matched to a gbfs feed. The recommended
argument is a system ID supplied in the output of [get_gbfs_cities()], but will
also attempt to match to the URL of an active .json feed or city name.}

\item{directory}{Optional. Path to a folder (or folder to be 
created) where the feed will be saved.}

\item{file}{Optional. The name of the file to be saved (if \code{output} 
is set to \code{"save"} or \code{"both"}), as a character string. 
Must end in \code{".rds"}.}

\item{output}{Optional. The type of output method. If left as default, this
argument is inferred from the \code{directory} argument. If 
\code{output = "save"}, the object will be saved as an .rds object at 
# the given path. If \code{output = "return"}, the output will be returned 
as a dataframe object. Setting \code{output = "both"} will do both.}
}
\value{
The output of this function depends on the argument to \code{output}
and \code{directory}. Either a saved .rds object generated from the current 
station_information feed, a dataframe object, or both. If a saved feed of
the same type already exists at the filepath, the feed will be appended to
rather than overwritten.
}
\description{
Grab a dataframe giving the geographic location and other metadata of
bikeshare bikes not parked at bikeshare stations. Metadata for this dataset
can be found at: \url{https://github.com/MobilityData/gbfs/blob/master/gbfs.md}
}
\examples{
# grab the free bike status feed for portland, oregon's bikeshare program 
\donttest{get_free_bike_status(city = 
"https://gbfs.lyft.com/gbfs/1.1/pdx/en/free_bike_status.json",
output = "return")}
                     
}
\seealso{
[get_gbfs()] for a wrapper to call each of the \code{get_feed}
functions, [get_gbfs_cities()] for a dataframe of cities releasing gbfs
functions, and [get_which_gbfs_feeds()] for a dataframe of which feeds
are released by a given city.
}
