% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_locate.R
\name{orf_locate}
\alias{orf_locate}
\title{Parse ORF Coordinates from Prodigal FASTA Headers}
\usage{
orf_locate(in_seq_data = seq_data)
}
\arguments{
\item{in_seq_data}{A data frame with two columns:
\describe{
\item{\code{SeqName}}{ORF identifier (Prodigal format: \verb{>ORF_id # start # end # strand # ...}).}
\item{\code{Sequence}}{ORF sequence.}
}
Example:
\code{"Kuafubacteriaceae--GCA_016703535.1---JADJBV010000001.1_1 # 74 # 1018 # 1 # ..."}
Can be imported from \strong{Prodigal} FASTA using:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{seq_data <- Biostrings::readBStringSet("Prodigal.fasta",format="fasta", nrec=-1L, skip=0L, seek.first.rec=FALSE, use.names=TRUE) \%>\%
  data.frame(Sequence = .) \%>\%
  tibble::rownames_to_column("SeqName")
}\if{html}{\out{</div>}}}
}
\value{
A data frame
}
\description{
Extracts ORF identifiers, start/end positions and strand
orientation directly from the FASTA headers produced by
Prodigal.  The resulting table is ready for downstream
gene-cluster analyses.
}
