% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Reference Batch Align}
\usage{
align(data_list, THR = 1e+05, use_ref_peak = TRUE, ref_peak = 92.1397)
}
\arguments{
\item{data_list}{a \emph{list} object. Data extracted from each cdf file,
ideally the output from extract_data().}

\item{THR}{a \emph{float} object. Threshold for peak intensity. Should be a
number between the baseline value and the highest peak intensity. Default
is THR = 100000.}

\item{use_ref_peak}{a \emph{boolean} object. Determines if an initial shift
to a given reference peak, default is toluene, should be done before aligning
all other peaks above given threshold THR. Default is TRUE.}

\item{ref_peak}{a \emph{float} object. The m/z value of the reference peak
for optional initial shift. Default is 92.1397 (toluene).}
}
\value{
A \emph{list} object. List of aligned data from each cdf file and a
list of peaks that were aligned for each file.
}
\description{
\code{align} aligns peaks from samples to a reference sample's
peaks.
}
\details{
This function aligns the peaks from any number of samples. Peaks are
aligned to the retention times of the first peak. If aligning to a reference
or standard sample, this should be the first in the lists for data frames and
for the mass data. The function comp_peaks() is used to find the
corresponding peaks. This function  will return a new list of TIC data frames
and a list of mass data. The first sample's data is unchanged, used as the
reference. Then a TIC data frame and mass data for each of the given samples
containing the peaks and time coordinates of the aligned peaks. The time
coordinates are aligned to the first sample's peaks, the peak height and MS
is unchanged.
}
\examples{
file1 <- system.file("extdata","sample1.cdf",package="gcxgclab")
file2 <- system.file("extdata","sample2.cdf",package="gcxgclab")
file3 <- system.file("extdata","sample3.cdf",package="gcxgclab")
frame1 <- extract_data(file1,mod_t=.5)
frame2 <- extract_data(file2,mod_t=.5)
frame3 <- extract_data(file3,mod_t=.5)
aligned <- align(list(frame1,frame2,frame3))
plot_peak(aligned$Peaks$S1,aligned$S1,title="Reference Sample 1")
plot_peak(aligned$Peaks$S2,aligned$S2,title="Aligned Sample 2")
plot_peak(aligned$Peaks$S3,aligned$S3,title="Aligned Sample 3")

}
