% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ms.R
\name{plot_ms}
\alias{plot_ms}
\title{Plots the mass spectra of a peak.}
\usage{
plot_ms(ms, title = "Mass Spectrum")
}
\arguments{
\item{ms}{a \emph{data.frame} object. A data frame of the mass values and the
percent intensity values, ideally the output of find_ms().}

\item{title}{a \emph{string} object. Title placed at the top of the plot.
Default title "Mass Spectrum".}
}
\value{
A \emph{ggplot} object. A line plot of the mass spectra data. The
mass values vs the percent intensity values as a percent of the highest
intensity.
}
\description{
\code{plot_ms} Plots the mass spectra of a peak.
}
\details{
This function produces a line plot of the mass spectra data. The
mass values vs the percent intensity values as a percent of the highest
intensity using \code{\link[ggplot2]{ggplot}} from ggplot2 package
\insertCite{ggplot2}{gcxgclab}.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
mz <- find_ms(frame, t_peak=peaks$'T'[1])
plot_ms(mz)

}
\references{
\insertAllCited{}
}
