% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gdal_formats}
\alias{gdal_formats}
\title{Retrieve information on GDAL format drivers for raster and vector}
\usage{
gdal_formats(format = "")
}
\arguments{
\item{format}{A character string containing a driver short name. By default,
information for all configured raster and vector format drivers will be
returned.}
}
\value{
A data frame containing:
\itemize{
\item the format short name
\item file extension(s) if applicable (space-delimited string), or empty string
(\code{""})
\item supports raster (logical)
\item supports multidimensional raster (logical)
\item supports vector (logical)
\item supports geography network (logical)
\item read/write flags (concatenated string, \code{ro} is read-only, \code{w} supports
CreateCopy, \verb{w+} supports Create, and \code{u} supports Update is reported if
GDAL >= 3.11)
\item supports virtual I/O e.g. /vsimem/ (logical)
\item supports subdatasets (logical)
\item supported SQL dialects reported if GDAL >= 3.6 (e.g.,
\code{"NATIVE OGRSQL SQLITE"})
\item creation raster data types (e.g., \code{"Byte Int16 UInt16 Float32"} etc.)
\item creation vector field types (e.g.,
\code{"Integer Integer64 Real String Date DateTime Binary"} etc.)
\item creation field sub-types (e.g., \code{"Boolean Int16 Float32 JSON"} etc.)
\item supports multiple vector layers reported if GDAL >= 3.4 (logical)
\item supports reading field domains if GDAL >= 3.5 (logical)
\item creation field domain types if GDAL >= 3.5 (supported values are \code{Coded},
\code{Range} and \code{Glob})
}
}
\description{
\code{gdal_formats()} returns a table of the supported raster and vector
formats, with information about the capabilities of each format driver.
}
\note{
Virtual I/O refers to operations on GDAL Virtual File Systems. See
\url{https://gdal.org/en/stable/user/virtual_file_systems.html#virtual-file-systems}.
}
\examples{
gdal_formats() |> str()

gdal_formats("GPKG")
}
