% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigcv.R
\name{print.eigcv}
\alias{print.eigcv}
\title{Print cross-validated eigenvalues}
\usage{
\method{print}{eigcv}(x, ...)
}
\arguments{
\item{x}{An \code{eigcv} object created by a call to \code{\link[=eigcv]{eigcv()}}.}

\item{...}{Ignored.}
}
\value{
\code{x}, but invisibly.
}
\description{
Print cross-validated eigenvalues
}
\examples{

library(fastRG)

set.seed(27)

B <- matrix(0.1, 5, 5)
diag(B) <- 0.3

model <- sbm(
  n = 200,
  B = B,
  expected_degree = 20,
  poisson_edges = FALSE,
  allow_self_loops = FALSE
)

A <- sample_sparse(model)

eigs<- eigcv(A, k_max = 7)
eigs

plot(eigs, type = "z-score")    # default
plot(eigs, type = "adjacency")
plot(eigs, type = "laplacian")


}
