% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpgee.R
\name{qpgeeControl}
\alias{qpgeeControl}
\title{Control Parameters for qpgee}
\usage{
qpgeeControl(
  epsilon = 1e-04,
  decay = 1,
  maxit = 100,
  trace = FALSE,
  standardize = FALSE,
  shrinkCutoff = 1e-04
)
}
\arguments{
\item{epsilon}{Convergence tolerance for the parameter estimates. Iteration stops
when the maximum change in coefficients is below this value.}

\item{decay}{Decay rate of learning step.}

\item{maxit}{Maximum number of iterations.}

\item{trace}{Logical indicating if output should be produced for each iteration.
(You can decide how much information to show inside the C++/R loop.)}

\item{standardize}{Logical indicating whether to scale X.}

\item{shrinkCutoff}{Threshold below which coefficients are shrunk to zero
(removal of “small” coefficients).}
}
\value{
A list with the components \code{epsilon}, \code{maxit},
  \code{trace}, and \code{shrinkCutoff}.
}
\description{
Provides control parameters for the Quantile Penalized Generalized Estimating
Equations (QPGEE) fitting procedure. Similar in spirit to `geese.control()` in
the geepack package.
}
\examples{
ctrl <- qpgeeControl(epsilon = 1e-5, maxit = 200, trace = TRUE)
}
