% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{methods}
\name{grab_ee_list}
\alias{grab_ee_list}
\title{Gets the .ee_i (observed estimating function) slot}
\usage{
grab_ee_list(object)
}
\arguments{
\item{object}{a \code{\linkS4class{sandwich_components}} object}
}
\description{
Gets the .ee_i (observed estimating function) slot
}
\examples{
myee <- function(data){
 function(theta){
   c(data$Y1 - theta[1],
   (data$Y1 - theta[1])^2 - theta[2])
  }
}

results <- m_estimate(
   estFUN = myee,
   data = geexex,
   root_control = setup_root_control(start = c(1,1)))

grab_ee_list(results@sandwich_components)
}
